//	DeviceManager.h
#ifndef	_H_DeviceManager
#define _H_DeviceManager

enum		{	kMinDepth, kMaxDepth	};

void			WalkIntersectingDevices(
							WindowPtr theWindow, 
							void (*Callback)(Rect *theRect, short depth, void *callbackData),
							void *callbackData);

Rect		GetGlobalWindowRect(WindowPtr theWindow);

int 		WindowScreenDepth(WindowPtr theWindow, int depthType);
int			RectDepth(Rect *theRect, int depthType);

int 		GetMaxPixelDepth(WindowPtr theWindow);
long		GetMaxCTabSeed(WindowPtr theWindow);
CTabHandle	GetMaxCTabHandle(WindowPtr theWindow);

void		CenterWindowToWorstDevice(WindowPtr	whichWindow);
void		CenterWindowToBestDevice(WindowPtr	whichWindow);
void		CenterWindowToMainDevice(WindowPtr  whichWindow) ;		/**  paul  12/5/90.  **/

Rect		ReturnLowestBitRect(void);
Rect		ReturnHighestBitRect(void);

void 		CenterRectToWorstDevice(Rect *theRect);
void		CenterRectToBestDevice(Rect *theRect);
void		CenterRectToMainDevice(Rect  *theRect) ;				/**  paul  12/5/90.  **/

GDHandle	ReturnHighestBitDevice(void);
GDHandle	ReturnLowestBitDevice(void);

GDHandle	GetEnclosingDevice(Rect *theRect);
Rect		ReturnEnclosingDeviceRect(Rect *theRectPtr);
short		GetEnclosingDeviceDepth(Rect *theRect);

Boolean		DeviceOkay(GDHandle theDevice);

int			get_device_rating(GDHandle theDevice);
Boolean		WindowOIsOffDeskTop(WindowPtr theWindow);
Boolean		RectIsOffDeskTop(Rect *theRect);

Rect		ReturnMainDeviceRect(void);
Rect		GetDesktopRect(void);

Boolean		RectOnScreen(Rect *theRect);
Boolean		WindowOnScreen(WindowPtr theWindow);

Rect		GetMBarRect(void);


#define	FOR_EACH_GDEVICE(_GDHANDLE)				\
	for (										\
		(_GDHANDLE) = GetDeviceList();			\
		(_GDHANDLE) != NULL;					\
		(_GDHANDLE) = GetNextDevice(_GDHANDLE)	\
	)

#define	FOR_EACH_OKAY_GDEVICE(_GDHANDLE)		\
	FOR_EACH_GDEVICE(_GDHANDLE)					\
		if (DeviceOkay(_GDHANDLE))


#endif
